import { StarXpandCommand } from "star-io10-web";

export class LabelSample01_For203dpi_JapaneseFoodLabelLunchBox_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // モデルにより対応する文字エンコーディング指定APIが異なります。
            // 下記ページのSupported Modelを参照し、ご利用のモデルが対応するAPIを使用してください。
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-cjk-character-priority.html
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-second-priority-character-encoding.html
            //.styleSecondPriorityCharacterEncoding(CharacterEncodingType.Japanese)

            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 72.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    48.0,
                    72.0,
                  )
                    .setRoundCorner(true)
                    .setCornerRadius(2.0),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    1.0,
                    10.0,
                    47.0,
                    10.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    1.0,
                    27.0,
                    47.0,
                    27.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    1.0,
                    44.0,
                    47.0,
                    44.0,
                  ),
                )
                .styleHorizontalPositionTo(0.0)
                .styleVerticalPositionTo(0.0)
                .actionPrintText("\n")
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText("${name}"),
                )
                .styleHorizontalPositionTo(1.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("消費期限 ${expiry_date}\n")
                .styleHorizontalPositionBy(2.0)
                .styleVerticalPositionBy(3.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${sku}",
                    StarXpandCommand.Printer.BarcodeSymbology.Jan13,
                  )
                    .setBarDots(2)
                    .setHeight(5.0)
                    .setPrintHri(true),
                )
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(38.0)
                    .styleVerticalPositionTo(18.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText("${price}"),
                )
                .styleHorizontalPositionTo(32.0)
                .styleVerticalPositionTo(23.0)
                .actionPrintText("お値段(円)")
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 20.0)
                    .setX(1.0)
                    .setY(28.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "原材料名：${ingredients}\n",
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(16.0, 14.0)
                    .setX(1.0)
                    .setY(46.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "保存方法：",
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(32.0, 14.0)
                    .setX(16.0)
                    .setY(46.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${preservation_method}",
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 14.0)
                    .setX(1.0)
                    .setY(58.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "製造者：${manufacturer}\n" +
                      "${address}\n" +
                      "TEL ${telephone_number}\n",
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "japanese_food_label_lunch_box_plastic.png",
                    40.0,
                    63.0,
                    48,
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : " 唐 揚 げ 弁 当 ",
    "expiry_date" : "12. 9. 8   22時",
    "sku" : "2100100114008",
    "price" : 400,
    "ingredients" : "ご飯(国内産)、鶏肉、おかず、調味料(アミノ酸等)、着色料(赤102、106、黄4)、(原材料の一部に小麦、大豆を含む)",
    "preservation_method" : "直射日光・高温多湿を避けお早めにお召上がりください。",
    "manufacturer" : "スターショップ",
    "address" : "XXX県XXX市XXX町123-1",
    "telephone_number" : "1234-567-890"
}`,
    );
  }
}
